<?php
extract( shortcode_atts( array(
	'type' => '',
	'dock' => '',
	'bg_image' => '',
	'bg_pos' => '',
	'bg_color' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-stretch-container' );

$type = sm_validate_with_array( $type, sm_get_stretch_container_types_array() );

$dock = sm_validate_with_array( $dock, sm_get_stretch_container_valigns_array() );

$id = uniqid( 'sm-stretch-container' ); // generate a unique ID for this map
$css_gen = new Inline_CSS_Generator( "sm-stretch-container." . $id, '' );
$scoped_css = '';

if ( !empty( $bg_image ) ) {
	$image_url = wp_get_attachment_url( $bg_image );
	if ( false !== $image_url ) {
		$scoped_css .= $css_gen->css( '', array( 'background-image' => 'url( ' . $image_url . ')' ) );
	}
}
if ( !empty( $bg_pos ) ) {
	$scoped_css .= $css_gen->css( '', array( 'background-position' => $bg_pos ) );
}
if ( !empty( $bg_color ) ) {
	$scoped_css .= $css_gen->css( '', array( 'background-color' => $bg_color ) );
}


if ( '' != $scoped_css ) {
	$css_class[] = $id; // use it as class instead of id.
}

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
if ( !empty( $type ) ) $wrapper_attributes[] = 'data-type="' . esc_attr( $type ) . '"';
if ( !empty( $dock ) ) $wrapper_attributes[] = 'data-dock="' . esc_attr( $dock ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="sm-stretch-inner">
	<?php echo sm_js_remove_wpautop( $content, true ); ?>
	</div>
</div>